/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import java.lang.reflect.Method;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MethodIteratorTest {
    public static Object[][] testNextMethodsData() throws NoSuchMethodException {
        Method xm1 = X.class.getDeclaredMethod("m1", new Class[0]);
        Method ym2 = Y.class.getDeclaredMethod("m2", new Class[0]);
        Method zm2 = Z.class.getDeclaredMethod("m2", new Class[0]);
        return new Object[][]{{X.class, Arrays.asList((Object[])new Method[]{xm1})}, {Y.class, Arrays.asList((Object[])new Method[]{ym2, xm1})}, {Z.class, Arrays.asList((Object[])new Method[]{zm2, ym2, xm1})}, {NoMethod.class, Arrays.asList((Object[])new Method[]{xm1})}};
    }

    @ParameterizedTest
    @MethodSource(value={"testNextMethodsData"})
    public void testNextMethods(Class clazz, List<Method> expectedMethods) {
        MethodIterator testInstance = new MethodIterator(clazz, Object.class);
        Assertions.assertThat((List)Iterables.collectToList(() -> testInstance, Function.identity())).isEqualTo(expectedMethods);
    }

    @Test
    public void testNext_throwsNoSuchElementException() {
        MethodIterator testInstance = new MethodIterator(X.class, Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MethodIterator)testInstance).next());
        testInstance = new MethodIterator(X.class, Object.class);
        testInstance.next();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MethodIterator)testInstance).next());
        testInstance = new MethodIterator(Object.class, Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MethodIterator)testInstance).next());
        testInstance = new MethodIterator(Object.class, Object.class);
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MethodIterator)testInstance).next());
    }

    static class NoMethod
    extends X {
        NoMethod() {
        }
    }

    static class Z
    extends Y {
        Z() {
        }

        private void m2() {
        }
    }

    static class Y
    extends X {
        Y() {
        }

        private void m2() {
        }
    }

    static class X {
        X() {
        }

        private void m1() {
        }
    }
}

